//
//  RadialGradientView.m
//  RadialGradients
//
//  Created by Patrick Geiller on 10/05/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import "RadialGradientView.h"


@implementation RadialGradientView

//@synthesize roundness;
@synthesize color1, color2;

//
//	awakeFromNib
//		setup our background gradient
//
- (void)awakeFromNib
{
/*	CGFloat components[12] = {	0.0, 0.0, 0.3, 1.0,
								0.5, 0.7, 1.1, 1.0
								};
*/
	

	[roundnessSlider setContinuous:YES];
	[zoomSlider setContinuous:YES];
	
	
	[self setValue:[NSColor blackColor] forKey:@"color1"];
	[self setValue:[NSColor whiteColor] forKey:@"color2"];
	
	[colorWell1 bind:@"value" toObject:self withKeyPath:@"color1" options:nil];
	[colorWell2 bind:@"value" toObject:self withKeyPath:@"color2" options:nil];
}


-(IBAction)UIChanged:(id)sender
{
	[self setNeedsDisplay:YES];
}


//
//	drawRect
//		draw our background gradient
//
- (void)drawRect:(NSRect)rect 
{
	float roundness = [roundnessSlider floatValue]*4/100.0;
	if (roundness == 0)	roundness = 0.0001;

	float zoom = [zoomSlider floatValue]/100.0;

	NSLog(@"%.2f %.2f", roundness, zoom);



	// Gradient
	size_t num_locations = 2;
	CGFloat locations[3] = { 0.0, 1.0 };

	NSColor* c1 = [color1 colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
	NSColor* c2 = [color2 colorUsingColorSpaceName:NSCalibratedRGBColorSpace];

/*	CGFloat components[8] = {	0.0, 0.0, 0.0, 1.0,
								1.5, 1.7, 1.1, 1.0
								};
*/								
	CGFloat components[8] = {	[c1 redComponent], [c1 greenComponent], [c1 blueComponent], 1.0,
								[c2 redComponent], [c2 greenComponent], [c2 blueComponent], 1.0,
								};
	CGColorSpaceRef colorspace = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
	CGGradientRef backgroundGradient = CGGradientCreateWithColorComponents(colorspace, components, locations, num_locations);
	CGColorSpaceRelease(colorspace);

	[[NSColor whiteColor] setFill];
	NSBezierPath* path = [NSBezierPath bezierPathWithRect:rect];
	[path fill];

	float width = [self frame].size.width;
	float height = [self frame].size.height;

	CGContextRef ctx = [[NSGraphicsContext currentContext] graphicsPort]; 	
	CGContextScaleCTM(ctx, 1, roundness);

	float w = width/2;
	float y1 = height/roundness;
	float y2 = 	y2 = 0-w;

	CGContextDrawRadialGradient(ctx, backgroundGradient, 
								CGPointMake(width/2, y1), w,
								CGPointMake(width/2, y2), w,
								0);

	CGGradientRelease(backgroundGradient);
}

@end

/*
//
//  RadialGradientView.m
//  RadialGradients
//
//  Created by Patrick Geiller on 10/05/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import "RadialGradientView.h"


@implementation RadialGradientView

//@synthesize roundness;
@synthesize color1, color2;

//
//	awakeFromNib
//		setup our background gradient
//
- (void)awakeFromNib
{
	[roundnessSlider setContinuous:YES];
	[zoomSlider setContinuous:YES];
	
	
	[self setValue:[NSColor blackColor] forKey:@"color1"];
	[self setValue:[NSColor whiteColor] forKey:@"color2"];
	
	[colorWell1 bind:@"value" toObject:self withKeyPath:@"color1" options:nil];
	[colorWell2 bind:@"value" toObject:self withKeyPath:@"color2" options:nil];


    [NSTimer scheduledTimerWithTimeInterval:1.0/60.0 target: self selector:@selector(timer) userInfo: nil repeats:YES];

}

float a = 0;

- (void)timer
{
	NSLog(@"timer %.2f", a);
	[self setNeedsDisplay:YES];
	a += 0.01;
}


-(IBAction)UIChanged:(id)sender
{
	[self setNeedsDisplay:YES];
}


//
//	drawRect
//		draw our background gradient
//
- (void)drawRect:(NSRect)rect 
{
	float roundness = [roundnessSlider floatValue]*4/100.0;
	if (roundness == 0)	roundness = 0.0001;

	float zoom = [zoomSlider floatValue]/100.0;

//	NSLog(@"%.2f %.2f", roundness, zoom);



	// Gradient
	size_t num_locations = 2;
	CGFloat locations[3] = { 0.0, 1.0 };

	NSColor* c1 = [color1 colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
	NSColor* c2 = [color2 colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
								
	CGFloat components[8] = {	[c1 redComponent], [c1 greenComponent], [c1 blueComponent], 1.0,
								[c2 redComponent], [c2 greenComponent], [c2 blueComponent], 1.0,
								};
	CGColorSpaceRef colorspace = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
	CGGradientRef backgroundGradient = CGGradientCreateWithColorComponents(colorspace, components, locations, num_locations);
	CGColorSpaceRelease(colorspace);

	[[NSColor whiteColor] setFill];
	NSBezierPath* path = [NSBezierPath bezierPathWithRect:rect];
	[path fill];

	float width = [self frame].size.width;
	float height = [self frame].size.height;

	CGContextRef ctx = [[NSGraphicsContext currentContext] graphicsPort]; 	
//	CGContextScaleCTM(ctx, 1, roundness);

	float w = width/2;
	float y1 = height/roundness;
	float y2 = 	y2 = 0-w;

	float tt = 400;
	CGContextTranslateCTM(ctx, tt, tt/2);
	CGContextRotateCTM(ctx, a);
	CGContextTranslateCTM(ctx, -tt, -tt/2);

	CGContextDrawRadialGradient(ctx, backgroundGradient, 
								CGPointMake(width/2, y1), w,
								CGPointMake(width/2, y2), w,
								0);

	CGGradientRelease(backgroundGradient);

	[[NSColor blackColor] set];
	[[NSBezierPath bezierPathWithRect:NSMakeRect(10, 10, 400, 400)] stroke];

}

@end

*/